﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Win32;
using Winfoot_7_SDK;

namespace WinfootDefaultSystemPlugin.Controls.Strategy
{
    public interface IForegroundFlashCountStrategy
    {
        void Write(int i);
        WFRegistry Read();
        List<WFRegistry> BackUp();
    }

    public class ForegroundFlashCountDefaultStrategy : ICorrespondenceOS, IForegroundFlashCountStrategy
    {
        public ForegroundFlashCountDefaultStrategy()
        {
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
#if DEBUG                                      
                                           OS.WindowsVista_SP2,
                                           OS.WindowsSeven
#endif
                                       };
        }

        private string RegName = "ForegroundFlashCount";

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        #region IAdditionalWorkerThreadsStrategy メンバ

        public void Write(int i)
        {
            RegistryKey registryKey =
                Registry.CurrentUser.CreateSubKey(
                    @"Control Panel\Desktop");

            registryKey.SetValue(RegName, i);
        }

        public WFRegistry Read()
        {
            RegistryKey registryKey =
                Registry.CurrentUser.OpenSubKey(
                    @"Control Panel\Desktop");

            return new WFRegistry(@"HKEY_CURRENT_USER\Control Panel\Desktop", RegName,
                              registryKey.GetValue(RegName, 20000), RegistryValueKind.DWord, RegOperation.KeyWrite);



        }

        public List<WFRegistry> BackUp()
        {
            return new List<WFRegistry> { Read() };
        }

        #endregion
    }

    public class ForegroundFlashCountController
    {
        public ForegroundFlashCountController(ForegroundFlashCount foregroundFlashCount,
                                                         IForegroundFlashCountStrategy strategy)
        {
            ForegroundFlashCount = foregroundFlashCount;
            Strategy = strategy;
        }

        public ForegroundFlashCount ForegroundFlashCount { get; set; }
        public IForegroundFlashCountStrategy Strategy { get; set; }

        public void Read()
        {
            ForegroundFlashCount.SetForegroundFlashCountState(Convert.ToInt32(Strategy.Read().Value));
        }

        public void Write()
        {
            Strategy.Write(ForegroundFlashCount.GetForegroundFlashCountState());
        }

        public List<WFRegistry> BackUp()
        {
            return Strategy.BackUp();
        }
    }
}
